//
//  FacialExpression.swift
//
//  Created by CS193p Instructor.
//  Copyright © 2015-17 Stanford University. All rights reserved.
//
//  Modified by Steve for cs 326.

import Foundation

/**
 
 A model capturing facial expressions.  Facial Expressions
 capture the state of the *eyes* and *mouth*.
 
 In this case, those states are capture by two enumerations,
 `Eyes` and `Mouth`.
 
 This is an immutable struct with two producer methods that
 create slightly happier and slightly sadder expressions.
 
 */
public struct FacialExpression {
  enum Eyes: Int {
    case open
    case closed
    case squinting
  }
  
  enum Mouth: Int {
    case frown
    case smirk
    case neutral
    case grin
    case smile
    
    func sadder() -> Mouth {
      return Mouth(rawValue: rawValue - 1) ?? .frown
    }
    func happier() -> Mouth {
      return Mouth(rawValue: rawValue + 1) ?? .smile
    }
  }
  
  let eyes: Eyes
  let mouth: Mouth
  
  public func sadder() -> FacialExpression {
    return FacialExpression(eyes: self.eyes, mouth: self.mouth.sadder())
  }
  
  public func happier() -> FacialExpression {
    return FacialExpression(eyes: self.eyes, mouth: self.mouth.happier())
  }
  
}

