import element.*;
import java.awt.Color;

public class mandelPic
{
    final static int WIDTH = 200;
    final static int HEIGHT = 200;
    static DrawingWindow d;
    public static void colorTest()
    {
        int i;
        for (i = 0; i < 200; i++)
        {
            float pct = (float)(i/200.0);
            d.setForeground(new Color(pct,pct,pct));
            d.draw(new Line(i,0,i,200));
        }
    }

    public static void drawMandelbrot(double x0, double y0, double w, double h,
                                 int col, int row, int iw, int ih)
    {
        int r, c;
        for (r = 0; r < ih; r++)
        {
            for (c = 0; c < iw; c++)
            {
                double x;
                double y;
                x = x0+c*(w/iw);
                y = y0+r*(h/ih);
                int p = Mandelbrot.man(x,y);
                if (p < 0) p = 0;
                if (p > 255) p = 255;
                d.setForeground(new Color(p,p,p));
                d.draw(new Pt(col+c,row+r));
            }
        }
    }

    public static Rect scan()
    {
        Pt p = d.awaitMousePress();
        Pt q = p;
        Pt q0;
        Rect r = new Rect(p,q);
        d.setForeground(Color.black);
        d.invertMode();
        d.draw(r);
        while (d.mousePressed())
        {
            q0 = d.getMouse();
            if (!q0.equals(q))
            {
                d.draw(r);
                q = q0;
                r = new Rect(p,q);
                d.draw(r);
            }
        }
        d.draw(r);
        if (r.width() == 0) return null;
        else return r;
    }

    public static void main(String args[])
    {
        d = new DrawingWindow(WIDTH,HEIGHT);
        ConsoleWindow c = new ConsoleWindow();
        double x0,y0,w,h;
        double cx0,cy0,cw,ch;
        cx0 = x0 = c.input.readDouble();
        cy0 = y0 = c.input.readDouble();
        cw = w = c.input.readDouble();
        ch = h = c.input.readDouble();
        c.out.println("Picture is ("+x0+","+y0+") "+w+"x"+h);
        while (true)
        {
            d.clear(d.bounds());
            drawMandelbrot(cx0,cy0,cw,ch,0,0,WIDTH,HEIGHT);
            c.out.println("Scan new rectangle");
            Rect r = scan();
            if (r == null)
            {
                cx0 = x0; cy0 = y0; cw = w; ch = h;
            } else {
                cx0 = cx0 + cw/(double)WIDTH*(double)r.left();
                cy0 = cy0 + ch/(double)HEIGHT*(double)r.top();
                cw = cw * (double)r.width()/(double)WIDTH;
                ch = ch * (double)r.height()/(double)HEIGHT;
            }
            c.out.println("Picture is ("+cx0+","+cy0+") "+cw+"x"+ch);
        }
    }
}
