class Semaphore
{
    private int count;  // number of resources currently available

    public Semaphore(int number)
    // pre: number > 0
    // post: construct a binary semaphore; controls a single resource
    {
        count = number;
    }

    public Semaphore()
    // post: construct a binary semaphore; controls a single resource
    {
        this(1);
    }

    synchronized public void acquire()
    // post: awaits allocation of a resource
    {
        while (count <= 0)
        {
            try {
                wait();
            } catch (Exception e) { System.exit(0); };
        }
        count--;
    }

    synchronized public void release()
    // post: frees resource
    {
        count++;
        notify();
    }

    public void P()
    // post: acquire resource
    {
        acquire();
    }

    public void V()
    // post: release resource
    {
        release();
    }
}
