/*
 * Support for generating mandelbrot images.
 * A good area to start investigation is
 *    (x0,top) = (-2.0,-2.0), rw = rh = 4.0
 * (c) 1993 duane a. bailey
 */
public class Fractal
{
    static int mandelbrot(double re, double im)
    // post: computes the rate of divergence of z, Mandelbrot's function
    {
        double re0 = re, im0 = im;
        double r2,i2;
        int count;
        for (count = 0; count < 255; count++) {
            r2 = re * re; i2 = im * im; // square (im,re)
            if (r2 + i2 > 4.0) break;   // halt if magnitude > 2
            im = 2 * im * re + im0;     // add (im,re) to square
            re = r2 - i2 + re0;
        }
        return 255-count; // count: 255=> converges, 0=> diverges fast
    }

    static int julia(double re, double im, double mu_re, double mu_im)
    // post: computes the rate of divergence of z, the Julia set
    {
        double re0 = re, im0 = im;
        double r2,i2;
        int count;
        for (count = 0; count < 64; count++) {
            r2 = re * re; i2 = im * im; // square (im,re)
            if (r2 + i2 > 4.0) break;   // halt if magnitude > 2
            im = 2 * im * re + mu_re;   // add (im,re) to square
            re = r2 - i2 + mu_im;
        }
        return 255-4*count; // count: 255=> converges, 0=> diverges fast
    }
}
