import element.*;

public class Swapper
{
    public static void swap(int a, int b)
    // post: fails to swap a and b
    {
        int temp;
        temp = a;
        a = b;
        b = temp;
    }

    public static void swap(Number a, Number b)
    // pre: a and b are non-null references to Numbers
    // post: the values of a and b are exchanged
    {
        int temp;
        temp = a.value;
        a.value = b.value;
        b.value = temp;
    }
    
    public static void main(String args[])
    {
        ConsoleWindow c = new ConsoleWindow();
        Number big = new Number();
        Number small = new Number();
        
        big.value = -10;
        small.value = 10;

        swap(small,big);

        c.out.println("small="+small.value+", big="+big.value);
    }
}
/*
small=-10, big=10
*/

