import java.util.Random;
import element.*;
public class Die
{
    private int faces;          // shape of die
    private int faceValue;      // current value of die
    private static Random rand = null; // shared generator
    
    public Die(int n)
    // pre: n >= 1
    // post: construct a randomly oriented die with n faces
    {
        if (rand == null)
        {
            rand = new Random();
        }
        faces = n;
        roll();
    }
    
    public Die()
    // post: construct a randomly oriented die with 6 faces
    {
        this(6);
    }        

    public void roll()
    // post: re-select the upward-pointing face
    {
        faceValue = 1+(Math.abs(rand.nextInt())%faces);
    }

    public int value()
    // post: return the current value of the die
    {
        return faceValue;
    }
}
