import java.util.Random;
import element.*;
public class CubeDie extends Die
{
    private Pt center;  // center of die, when drawn in window

    public CubeDie(Pt center)
    // post: construct a randomly oriented die with 6 faces;
    //       drawn about center
    {
        super(6);
        this.center = new Pt(center);
    }        

    public CubeDie()
    // post: construct a randomly oriented die with 6 faces
    //       drawn about origin
    {
        this(new Pt(0,0));
    }        

    public void moveTo(Pt c)
    // post: centers the die at the location c
    {
        center = new Pt(c);
    }

    public void drawOn(DrawingWindow d)
    // post: draw the die on the drawing window about center
    {
        Circle pip = new Circle(center.x()-15,center.y()-15,4);
        RoundRect r = 
            new RoundRect(center.x() - 22, center.y()-22,34,34,5,5);
        
        d.draw(r);
        if (value() != 1) d.fill(pip); // northwest
        pip.move(20,0);
        if (value() > 3) d.fill(pip);  // northeast
        pip.move(-20,10);
        if (value() == 6) d.fill(pip); // west
        pip.move(10,0);
        if (value()%2 == 1) d.fill(pip); // center
        pip.move(10,0);
        if (value() == 6) d.fill(pip); // east
        pip.move(-20,10);
        if (value() > 3) d.fill(pip); // southwest
        pip.move(20,0);
        if (value() > 1) d.fill(pip); // southeast
    }

    public String toString()
    // post: return a string representation of the CubeDie
    {
        return "<CubeDie: "+value()+">";
    }
}
