import element.*;

public class Button
{
    private DrawingWindow targetWindow; // the window
    private Rect activeArea;    // the area we can press w/mouse
    private Text label;         // the label on the area

    public Button(DrawingWindow d, Rect r, String l)
    // pre: d,r,l non-null; l.width <= r.width
    // post: button with text l displayed on window d
    {
        targetWindow = d;
        activeArea = new Rect(r);
        label = new Text(l);
        label.center(r.center());
        draw();
    }

    private void draw()
    // pre: button not showing
    // post: paints button
    {
        targetWindow.draw(activeArea);
        targetWindow.draw(label);
    }

    private void clear()
    // pre: button showing
    // post: erases button
    {
        targetWindow.clear(activeArea);
    }

    public String label()
    // post: return the label of the button
    {   
        return label.string();
    }

    public void label(String l)
    // pre: l.width < activeArea.width
    // post: changes the label and repaints the button
    {   
        clear();
        label = new Text(l);
        label.center(activeArea.center());
        draw();
    }

    public Rect area()
    // post: returns the active area of the button
    {
        return new Rect(activeArea);
    }

    public void area(Rect r)
    // pre: r.width >= label.width
    // post: sets button active area to r, updates button on screen
    {
        clear();
        activeArea = new Rect(r);
        label.center(activeArea.center());
        draw();
    }

    public boolean contains(Pt p)
    // post: returns true iff p within the button
    {
        return activeArea.contains(p);
    }
}
