import element.*;
import java.awt.Color;
public class life2
{
    static int size = 10;
    static DrawingWindow d;

    public static void initialize(boolean board[][])
    {
        int n = board.length;
        int r,c;
        for (r = 0; r < n; r++)
        {
            for (c = 0; c < n; c++)
            {
                board[r][c] = false;
            }
        }
    }   
    
    public static void setup(boolean board[][])
    {
        int n = board.length;
        paint(board);
        do
        {
            Pt press = d.awaitMousePress();
            Pt release = d.awaitMouseRelease();
            int pr = press.y()/size;
            int pc = press.x()/size;
            int rr = release.y()/size;
            int rc = release.x()/size;
            if (pr == rr && pc != rc) 
            {
                initialize(board);
            } else {
                if (pr != rr || pc != rc) break;
                board[pr][pc] = !board[pr][pc];
            }
            paint(board);
        } while (true);
    }

    public static void paint(boolean board[][])
    {
        int n = board.length;
        int r,c;
        d.hold();
        d.clear(d.bounds());
        for (r = 0; r < n; r++)
        {
            for (c = 0; c < n; c++)
            {
                if (board[r][c])
                {
                    int pop = neighbors(board,r,c);
                    if (pop < 3) d.setForeground(Color.yellow);
                    else if (pop > 4) d.setForeground(Color.red);
                    else if (pop == 3) d.setForeground(Color.blue);
                    else if (pop == 4) d.setForeground(Color.green);
                    d.fill(new Oval(c*size,r*size,size,size));
                }
            }
        }
        d.release();
    }


    public static void simulate(boolean board[][])
    {
        int n = board.length;
        boolean work[][] = new boolean[n][n];
        int r,c;
        int pop;
        for (r = 0; r < n; r++)
        {
            for (c = 0; c < n; c++)
            {
                pop = neighbors(board,r,c);
                if (pop == 3 && !board[r][c])
                {
                    work[r][c] = true;
                } else if (board[r][c] && (pop <= 1 || pop >= 4))
                {
                    work[r][c] = false;
                } else work[r][c] = board[r][c];
            }
        }
        for (r = 0; r < n; r++)
        {
            for (c = 0; c < n; c++)
            {
                board[r][c] = work[r][c];
            }
        }
        paint(board);
    }

    public static int neighbors(boolean board[][], int row, int col)
    {
        int n = board.length;
        int r, c;
        int pop = 0;
        for (r = -1; r <= 1; r++)
        {
            for (c = -1; c <= 1; c++)
            {
                if (r != 0 || c != 0)
                if (board[(row+n+r)%n][(col+n+c)%n]) pop++;
            }
        }
        return pop;
    }

    public static void main(String args[])
    {
        d = new DrawingWindow(600,600);
        size = 10;
        int n = d.bounds().width()/size;
        boolean board[][] = new boolean[n][n];
        
        initialize(board);
        do
        {
            setup(board);
            while (true)
            {
                if (d.mousePressed()) break;
                simulate(board);
            }
            d.awaitMouseRelease();
        } while (true);
    }
}
