import element.*;

public class News
{
    static DrawingWindow d;
    static ConsoleWindow c;

    public static void drawButtons(RoundRect buttons[], String labels[])
    // pre: the labels are valid
    // post: labels (and associated buttons) are drawn on the screen
    {
        final int width = 30, height = 10;
        final int spacing = 5;
        int n = labels.length;
        int i;

        // the template
        RoundRect template = new RoundRect(10, 10, width, height);

        for (i = 0; i < n; i++)
        {
            // copy template
            buttons[i] = new RoundRect(template);
            d.draw(buttons[i]);
            d.draw(new Text(labels[i],
                            buttons[i].right()+spacing,
                            buttons[i].bottom()));
            // move template downward
            template.move(0, height+spacing);
        }
    }

    public static int selectButton(RoundRect buttons[])
    // pre: buttons are valid, and drawn on screen
    // post: the index of the button pressed is returned
    {
        int i;
        Pt pressPoint;
        int which = -1;

        pressPoint = d.awaitMousePress();
        d.awaitMouseRelease();
        for (i = 0; i < buttons.length; i++)
        {
            if (buttons[i].contains(pressPoint)) which = i;
        }
        if (which == -1) which = selectButton(buttons);
        return which;
    }

    public static void main(String args[])
    {
        d = new DrawingWindow();
        c = new ConsoleWindow();
        String labels[] = { "all", "fits", "news", "print", 
                            "that", "the", "stop" };
        RoundRect buttons[] = new RoundRect[labels.length];
        int index;

        drawButtons(buttons,labels);
        while (true)
        {
            index = selectButton(buttons);
            // stop on the press of button "stop"
            if (labels[index].equals("stop")) break;
            c.out.print(labels[index]+" ");
            c.out.flush();  // make word show up immediately in console
        }
        c.out.println();
    }
}
/*
print all the news that fits the print
 */
