import element.*;

public class Rot13
{
    public static char rot13(char c)
    // post: ciphers c: maps alphabetic characters 13 away in alphabet
    {
        int position;
        final int rotation = 13;
        if (('a' <= c) && (c <= 'z'))
        {
            position = c - 'a';
            position = (position + rotation)%26;
            c = (char)(position + 'a');
        }
        else if (('A' <= c) && (c <= 'Z'))
        {
            position = c - 'A';
            position = (position + rotation)%26;
            c = (char)(position + 'A');
        }
        return c;
    }

    public static String rot13(String s)
    // pre: s is non-null
    // post: the alphabetic characters of a string are rot13 encoded
    {
        String result = "";
        int i;
        for (i = 0; i < s.length(); i++)
        {
            result += rot13(s.charAt(i));
        }
        return result;
    }

    public static void main(String args[])
    // post: rot13 encode the console input; output on console
    {
        ConsoleWindow c = new ConsoleWindow();
        while (!c.input.eof())
        {
            c.out.println(rot13(c.input.readLine()));
        }
        System.exit(0);
    }
}
