import element.*;

public class Scribble
{
    static DrawingWindow d;

    public static Pt opposite(Pt p)
    // pre: p is a valid point
    // post: returns the point that is opposite of p in d
    {
        // note reference of static instance variable, d
        int windowRight = d.bounds().right();
        int windowBottom = d.bounds().bottom();
        return  new Pt(windowRight-p.x(), windowBottom-p.y());
    }

    public static void draw()
    // pre: mouse is down
    // post: draws mirrored curve until mouse is released
    {
        // note reference of static instance variable, d 
        Pt current, next;
        current = d.getMouse();         // initial location
        while (d.mousePressed())
        {
            next = d.getMouse();        // get next mouse position

            d.moveTo(current);          // draw the "right" segment
            d.lineTo(next);
            d.moveTo(opposite(current)); // draw mirrored segment
            d.lineTo(opposite(next));   // simplified: not passing d

            current = next;
        }
        // mouse is released
    }

    public static void main(String args[])
    {
        d = new DrawingWindow();

        while (true)                    // draw forever
        {
            d.awaitMousePress();        // while mouse pressed
            draw();                     // draw mirrored curve
        }
    }
}
        
