import element.*;
import java.awt.Color;
public class Hash
{
    public static void drawHashAt(DrawingWindow d, Pt center)
    // pre: d is a valid drawing window, center is a non-null point
    // post: draw a hash mark centered at center in drawing window d
    {
        d.moveTo(center);    // move to center of hash mark
        d.move(-10,0);  // move left
        d.line(20,0);   // draw horizontal axis
        d.move(-10,-10); // move up
        d.line(0,20);   // draw vertical axis
    }

    public static void main(String args[])
    {
        DrawingWindow d = new DrawingWindow();
        Rect stop = new Rect(0,0,10,10);
        Pt pressPoint;
        d.draw(stop); // a button for stopping
        d.setForeground(Color.red);

        while (true) // potentially infinite
        {
            pressPoint = d.awaitMousePress();
            // mouse is down
            if (stop.contains(pressPoint)) break; // leave loop
            drawHashAt(d,pressPoint);
            d.awaitMouseRelease();
            // mouse is up
        }
        System.exit(0);
    }
}
