import element.*;

public class Bezier
{
    static DrawingWindow d;
    public static void main(String args[])
    {
        d = new DrawingWindow();
        Pt p0,c0,c1,p1;

        for (int i = 0; i < 5; i++) {
            p0 = d.awaitMousePress();
            c0 = d.awaitMouseRelease();
            c1 = d.awaitMousePress();
            p1 = d.awaitMouseRelease();
            bezier(p0,c0,c1,p1);
        }
    }

    public static Pt bezierPoint(Pt p0, Pt c0, Pt c1, Pt p1, double t)
    // pre: p0 and p1 are endpoints, c0 and c1 are control points
    //      0 <= t <= 1
    // post: returns the point along the Bezier curve determined
    //       by p0, c0, c1, p1, and t
    {
        double omt = 1.0-t;
        double x = omt*omt*omt*p0.x()+
                   3*omt*omt*t*c0.x()+
                   3*omt*t*t*c1.x()+
                   t*t*t*p1.x();
        double y = omt*omt*omt*p0.y()+
                   3*omt*omt*t*c0.y()+
                   3*omt*t*t*c1.y()+
                   t*t*t*p1.y();
        return new Pt((int)Math.round(x),(int)Math.round(y));
    }

    public static void bezier(Pt p0, Pt c0, Pt c1, Pt p1)
    // pre: p0, c0, c1, p1 all non-null
    // post: draws smooth curve from p0 toward c0, to p1 from c1
    {
        int cnt = 10;
        int i;
        d.moveTo(p0);
        for (i = 0; i <= cnt; i++)
        {
            d.lineTo(bezierPoint(p0,c0,c1,p1,i*(1.0/cnt)));
        }
    }
}
