// (c) 1998 duane a. bailey
import element.*;

public class Swim
{
    public static void main(String args[])
    {
        final double SECONDS_PER_HOUR = 60.0*60.0;
        final double FEET_PER_MILE = 5280.0;
        final double FEET_PER_METER = 39.37/12.0;
        final int    POOL_SIZE = 50;
        final double FEET_PER_LAP = POOL_SIZE*FEET_PER_METER;
        ConsoleWindow c = new ConsoleWindow();
        String first, last;
        int laps, minutes, seconds;
        double hours, distance, lapTime;

        c.out.println("What are your first and last names?");
        first = c.input.readString();
        last = c.input.readString();
        
        c.out.println("Thanks, "+first+".");
        c.out.println("How many "+POOL_SIZE+" meter laps did you swim?");
        laps = c.input.readInt();

        c.out.println("How long did it take you "+
                      "(in minutes and seconds)?");
        minutes = c.input.readInt();
        seconds = c.input.readInt();

        // Now compute total number of seconds and number of hours:
        seconds = seconds + 60*minutes;
        hours = seconds/SECONDS_PER_HOUR;

        // Now compute average lap time:
        lapTime = seconds/(double)laps;
        c.out.println("It took you, on average, "+lapTime
                      +" seconds per lap.");
        
        // Compute the total distance, in miles
        distance = laps*FEET_PER_LAP/FEET_PER_MILE;
        c.out.println("Your average speed was "+(distance/hours)
                      +" miles/hour.");
        c.out.println("You swim about "+Math.round(SECONDS_PER_HOUR/lapTime)
                      +" laps per hour!");
    }
}
/*
What are your first and last names?
Ray Tracer
Thanks, Ray.
How many 50 meter laps did you swim?
34
How long did it take you (in minutes and seconds)?
37 28
It took you, on average, 66.11764705882354 seconds per lap.
Your average speed was 1.691629933678421 miles/hour.
You swim about 54 laps per hour!
*/
