import element.*;

public class Shapes
{
    public static void main(String args[])
    {
        final int SCALE = 2;
        final int WIDTH = 200*SCALE;
        final int HEIGHT = 200*SCALE;
        final int W2 = WIDTH/2;
        final int H2 = HEIGHT/2;
        final int W4 = WIDTH/4;
        final int H4 = HEIGHT/4;
        final int WIDE3 = 80*SCALE;
        final int HIGH3 = 40*SCALE;
        DrawingWindow d = new DrawingWindow(WIDTH,HEIGHT);
        Rect outline;
        Oval sampleOval = new Oval(W4-WIDE3/2,H4-HIGH3/2,WIDE3,HIGH3);

        d.draw(sampleOval);

        final int RADIUS = 30*SCALE;
        Circle sampleCircle = new Circle(W2+W4,H4,RADIUS);
        d.draw(sampleCircle);

        final int W = 30*SCALE;
        final int H = 40*SCALE;
        final int WIDE = 80*SCALE;
        final int HIGH = 60*SCALE;
        RoundRect sampleRoundRect = new RoundRect(W4-WIDE/2,H2+H4-HIGH/2,
                                                  WIDE,HIGH,W,H);
        Oval cornerOval = new Oval(W4-WIDE/2,W2+W4-HIGH/2,W,H);

        d.draw(sampleRoundRect);

        final int WIDE2 = 40*SCALE;
        final int HIGH2 = 60*SCALE;
        final int START = 45;
        final int SWEEP = 200;
        Arc sampleArc = new Arc(W2+W4-WIDE2/2,H2+H4-HIGH2/2,WIDE2,HIGH2, START, SWEEP);
        d.draw(sampleArc);

        d.draw(new Rect(sampleOval));
        d.draw(new Line(W2+W4,H4,
                        W2+W4+(int)Math.round(RADIUS*Math.cos(Math.PI/7.0)),
                        H4-(int)Math.round(RADIUS*Math.sin(Math.PI/7.0))));
        d.draw(cornerOval);
        d.moveTo(W4-WIDE/2+W/2,H2+H4-HIGH/2);
        d.line(0,H);d.move(W/2,-H/2);
        d.line(-W,0);
        d.draw(new Rect(sampleArc));
        d.draw(new Line(W2+W4,H2+H4,
                        W2+W4+(int)Math.round(WIDE2/2*Math.cos(Math.PI/180.0*45.0)),
                        H2+H4-(int)Math.round(HIGH2/2*Math.sin(Math.PI/180.0*45.0))));
        d.draw(new Line(W2+W4,H2+H4,
                        W2+W4+(int)Math.round(WIDE2/2*Math.cos(Math.PI/180.0*245.0)),
                        H2+H4-(int)Math.round(HIGH2/2*Math.sin(Math.PI/180.0*245.0))));

    }
}
