import element.*;
import java.util.Random;

public class LoopTheMouse
{
    public static void main(String args[])
    {
        DrawingWindow d = new DrawingWindow();

        // construct a randomly placed rectangle
        final int SIZE = 50;
        Rect target = new Rect(0,0,SIZE,SIZE);
        Random generator = new Random();
        int centerX=Math.abs(generator.nextInt())%d.bounds().width();
        int centerY=Math.abs(generator.nextInt())%d.bounds().height();
        target.center(new Pt(centerX,centerY));

        // wait for the mouse to be pressed
        Pt mouse = d.awaitMousePress();

        // now draw rectangle and check for hit
        d.fill(target);

        ConsoleWindow c = new ConsoleWindow();
        c.out.println("Mouse in the target? "+target.contains(mouse));
    }
}




