// Implements a simple point class.
// (c) 1997 duane a. bailey
package element;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: Pt.java,v 2.2 1999/08/05 16:18:01 bailey Exp bailey $
 * @author duane a. bailey
 */
public class Pt implements Drawable
{
    private int h;
    private int v;

    /**
     */
    public Pt()
    // post: constructs a point object    
    {
	this(0,0);
    }

    /**
     * @param p 
     */
    public Pt(Pt p)
    // post: constructs a point, like p
    {
	h = p.h;
	v = p.v;
    }

    /**
     * @param x 
     * @param y 
     */
    public Pt(int x, int y)
    // post: constructs the point (x,y)
    {
	h = x;
	v = y;
    }

    /**
     * @return 
     */
    public int x()
    // post: returns the horizontal coordinate of the point
    {
	return h;
    }

    /**
     * @return 
     */
    public int y()
    // post: returns the vertical coordinate of the point
    {
	return v;
    }

    /**
     * @param x the new horizontal coordinate
     */
    public void x(int x)
    // post: sets the horizontal coordinate to x
    {
	h = x;
    }

    /**
     * @param newy 
     */
    public void y(int newy)
    // post: sets the new vertical coordinate
    {
	v = newy;
    }

    /**
     * @return 
     */
    public int left()
    // post: returns the horizontal coordinate
    {
	return h;
    }

    /**
     * @return 
     */
    public int right()
    // post: returns the horizontal coordinate
    {
	return h;
    }

    /**
     * @return 
     */
    public int top()
    // post: returns the vertical coordinate
    {
	return v;
    }

    /**
     * @return 
     */
    public int bottom()
    {
	return v;
    }
    
    /**
     * @param x 
     */
    public void left(int x)
    // post: sets the horizontal coordinate
    {
	h = x;
    }

    /**
     * @param x 
     */
    public void right(int x)
    // post: sets the horizontal coordinate
    {
	h = x;
    }

    /**
     * @param y 
     */
    public void top(int y)
    // post: sets the vertical coordinate
    {
	v = y;
    }

    /**
     * @param y 
     */
    public void bottom(int y)
    // post: sets the vertical coordinate
    {
	v = y;
    }
    
    /**
     * @return 
     */
    public int width()
    // post: returns 0
    {
	return 0;
    }

    /**
     * @return 
     */
    public int height()
    // post: returns 0
    {
	return 0;
    }

    /**
     * @param that 
     */
    public boolean contains(Pt that)
    // pre: that is not null
    // post: returns true if this and that are equal
    {
	return equals(that);
    }

    /**
     */
    public Pt center()
    // post: returns copy of this point
    {
	return new Pt(this);
    }
    
    /**
     * @param p 
     */
    public void center(Pt p)
    // pre: p is not null
    // post: sets this point to p's coordinates
    {
	moveTo(p);
    }

    /**
     * @param dx 
     * @param dy 
     */
    public void move(int dx, int dy)
    // post: moves point by (dx,dy)
    {
	h += dx;
	v += dy;
    }

    /**
     * @param x 
     * @param y 
     */
    public void moveTo(int x, int y)
    // post: sets point to (x,y)
    {
	h = x;
	v = y;
    }

    /**
     * @param p 
     */
    public void moveTo(Pt p)
    // pre: p is not null Pt
    // post: sets this to new p
    {
	moveTo(p.x(),p.y());
    }

    /**
     * @param d 
     */
    public void fillOn(DrawingWindow d)
    // pre: d is not null
    // post: draws this point on d
    {
	d.fillPt(h,v);
    }

    /**
     * @param d 
     */
    public void clearOn(DrawingWindow d)
    // pre: d is not null
    // post: erases this point from d
    {
	d.clearPt(h,v);
    }

    /**
     * @param d 
     */
    public void drawOn(DrawingWindow d)
    // pre: d is not null
    // post: draws this point on d
    {
	d.drawPt(h,v);
    }

    /**
     * @param p 
     * @return 
     */
    public boolean equals(Object p)
    // pre: p is not null
    // post: returns true if this and p are equal
    {
	Pt that = (Pt)p;
	return (this.h == that.h) &&
	       (this.v == that.v);
    }

    /**
     * @return 
     */
    public Object clone()
    // post: returns a new copy of this point
    {
	return new Pt(this);
    }

    /**
     * @return 
     */
    public int hashCode()
    // post: returns a value suitable as a code for hashing
    {
	return h+v;
    }
    
    /**
     * @return 
     */
    public String toString()
    // post: returns a string representation of this point
    {
	return "<Point: ("+h+","+v+")>";
    }
}

