// A drawable object interface.
// (c) 1997, 1998 duane a. bailey
package element;

/**
 * The interface describing graphic objects that can be drawn in a drawing window.
 *
 * @version $Id: Drawable.java,v 2.2 1999/08/05 16:18:01 bailey Exp bailey $
 * @author duane a. bailey
 */
public interface Drawable extends Cloneable
{
    /**
     * Return the height of the bounding box of the object
     * @return height of the bounding box of the object
     */
    public int height();
    // post: returns the height of the drawable object

    /**
     * Return the width of the bounding box of the object
     * @return the width of the bounding box of the object
     */
    public int width();
    // post: returns the width of the drawable object

    /**
     * Return the leftmost coordinate of bounding box of object
     * @return the leftmost coordinate of the bounding box of the object
     */
    public int left();
    // post: returns the left-most coordinate of the bounding
    //       box containing the drawable object
    
    /**
     * Return the rightmost coordinate of the bounding box of the object
     * @return the rightmost coordinate of the bounding box of the object
     */
    public int right();
    // post: returns the right-most coordinate of the bounding
    //       box containing the drawable object

    /**
     * Return the bottom coordinate of the bounding box of the object
     * @return the bottom coordinate of the bounding box of the object
     */
    public int bottom();
    // post: returns the bottom-most coordinate of the bounding
    //       box containing the drawable object
    
    /**
     * Return the top coordinate of the bounding box of the object
     * @return the top coordinate of the bounding box of the object
     */
    public int top();
    // post: returns the top-most coordinate of the bounding
    //       box containing the drawable object

    /**
     * Reset the center of the object to be at point p.  Dimensions remain unchanged
     *
     * @param p the new center of the object
     */
    public void center(Pt p);
    // post: sets the center of the bounding box of drawable to p;
    //       the dimensions remain the same
    
    /**
     * Return the center of the object
     *
     * @return the center of the object
     */
    public Pt center();
    // post: returns the center of the bounding box of
    //       the drawable object

    /**
     * Draw this object (in the current mode) on a drawing window
     *
     * @see element.DrawingWindow#draw
     * @see element.DrawingWindow#paintMode
     * @see element.DrawingWindow#invertMode
     * @param d the drawing window to be targeted
     */
    public void drawOn(DrawingWindow d);
    // post: draws outline of this object on window d;
    //       same as d.draw(this)

    /**
     * Draw a filled version of this object (in the current mode) on a drawing window
     *
     * @see element.DrawingWindow#fill
     * @see element.DrawingWindow#paintMode
     * @see element.DrawingWindow#invertMode
     * @param d the drawing window
     */
    public void fillOn(DrawingWindow d);
    // post: draws the interior of this object on window d;
    //       same as d.fill(this)

    /**
     * Erase a filled version of this object (in the current mode) on a drawing window
     *
     * @see element.DrawingWindow#clear
     * @param d the drawing window
     */
    public void clearOn(DrawingWindow d);
    // post: erases this object from window d;
    //       same as d.clear(this)
}
