// The console package (c) 1997 duane a. bailey and lyle a. mcgeoch
// A class supporting a single extensible line.
package element;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: ConsoleLine.java,v 2.1 1999/07/11 02:52:16 bailey Exp $
 * @author duane a. bailey
 */
class ConsoleLine
{
    int length;		// actual length of line
    int allocLength;	// size of allocated line
    byte[] data;	// actual data

    ConsoleLine()
    // post: generates an 80 character line
    {
	this(80);
    }

    ConsoleLine (int cols)
    // pre: cols >= 0
    // post: generates a line with cols locations
    {
	length = 0;
	allocLength = cols;
	data = new byte[cols];
    }

    synchronized public void append(byte b)
    // pre: b is a byte to be inserted into last line 	
    // post: when last line is available, b is inserted.
    {
	if (b == '\b') // backspace character
	{
	    if (length == 0) {
		return;
	    } else {
		length--;
	    }
	} else { // normal character
	    // possibly extend buffer, if necessary.
	    if (length >= allocLength)
	    {
		allocLength *= 2;
		byte newdata[] = new byte[allocLength];
		for (int i = 0; i < length; ++i) newdata[i] = data[i];
		data = newdata;
	    }
	    data[length++] = b;
	}
    }
	
    /**
     * @return 
     */
    public String toString()
    {
	String s = "<ConsoleLine: "+length+" chars=\"";
	for (int i = 0; i < length; i++)
	{
	    s += (char)data[i];
	}
	s += "\">";
	return s;
    }
}
