// The console package (c) 1997 duane a. bailey and lyle a. mcgeoch
// The class supporting the console keyboard input stream
package element;
import java.io.*;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: ConsoleKeyboard.java,v 2.1 1999/07/11 02:52:16 bailey Exp $
 * @author duane a. bailey
 */
class ConsoleKeyboard extends PipedInputStream
{
    PipedOutputStream outputPipe;
    ConsoleCanvas canvas;
    ConsoleLine lineBuffer;
	
    ConsoleKeyboard(ConsoleCanvas canvas)
    {
	this.canvas = canvas;
	try {
	    outputPipe = new PipedOutputStream(this);
	} catch (IOException e) {
	}
	lineBuffer = new ConsoleLine(80);
		
	canvas.setKeyboard(this);
    }
	
    void doKeyHit(byte b)
    {
	if (outputPipe == null) return;
	// remap delete key
	if (b == 127) b = (byte)'\b';
	if (b == (byte)'\r') b = (byte)'\n';
	if (b == 4)
	{
	    try {
		outputPipe.close();
		outputPipe = null;
	    } catch (IOException e) {
		throw new ConsoleException("Error terminating keyboard.");
	    }
	} else if (b == '\n') {
	    canvas.write(b);
	    try {
		outputPipe.write(lineBuffer.data, 0, lineBuffer.length);
		outputPipe.write(b);
		outputPipe.flush();
	    }
	    catch (IOException e) {
		throw new ConsoleException("Error reading from keyboard");
	    }
	    lineBuffer.length = 0;
	} else if ((b != '\b') || (lineBuffer.length != 0)) {
	    canvas.write(b);
	    lineBuffer.append(b);
	}
    }
}
