// Implements a simple Circle class.
// (c) 1997 duane a. bailey
package element;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: Circle.java,v 2.2 1999/08/05 16:18:01 bailey Exp bailey $
 * @author duane a. bailey
 */
public class Circle extends Oval
{
    /**
     * post: constructs a trivial circle at origin<br>
     * 
     */
    public Circle()
    // post: constructs a trivial circle at origin
    {
	this(0,0,0);
    }

    /**
     * post: constructs a Circle from a drawable<br>
     * 
     * @param r 
     */
    public Circle(Drawable d)
    // post: constructs a circle from a drawable object
    {
	this(d.center().x(),d.center().y(),Math.min(d.width(),d.height())/2);
    }

    /**
     * pre:  r >= 0<br>
     * post: constructs circle with center at (x,y), radius r<br>
     * 
     * @param x 
     * @param y 
     * @param r 
     */
    public Circle(int x, int y, int r)
    // pre:  r >= 0
    // post: constructs circle with center at (x,y), radius r
    {
	super(x-r,y-r,2*r,2*r);
    }

    /**
     * pre:  r >= 0
     * post: constructs circle with center p, radius r<br>
     * 
     * @param p 
     * @param r 
     */
    public Circle(Pt p, int r)
    // pre:  r >= 0
    // post: constructs circle with center p, radius r
    {
	this(p.x(),p.y(),r);
    }

    /**
     * post: return true iff point p is within this circle
     * @param p a point possibly within a circle
     * @return true iff p is within circle
     */
    public boolean contains(Pt p)
    // post: returns true iff p is within circle
    {
	int cx = left()+width()/2;
	int cy = top()+height()/2;
	int dx = p.x()-cx;
	int dy = p.y()-cy;
	// width is radius times 2, thus the 0.25
	return (dx*dx+dy*dy) <= (width*width/4);
    }

    /**
     * post: returns radius of circle<br>
     * @return radius of circle
     */
    public int radius()
    // post: returns radius of circle
    {
	return width/2;
    }

    /**
     * pre: r >= 0<br>
     * post: sets radius of the circle<br>
     *
     * @param r new circle radius
     */
    public void radius(int r)
    // pre: r >= 0<br>
    // post: sets radius of the circle
    {
	int d = 2*r;
	width(d);
	height(d);
    }

    /**
     * @param d 
     */
    public void fillOn(DrawingWindow d)
    // pre: d is a valid drawing window
    // post: the circle is filled on the drawing window d
    {
	d.fillCircle(left,top,width/2);
    }

    /**
     * @param d 
     */
    public void clearOn(DrawingWindow d)
    // pre: d is a valid drawing window
    // post: the circle is erased from the drawing window
    {
	d.clearCircle(left,top,width/2);
    }

    /**
     * @param d 
     */
    public void drawOn(DrawingWindow d)
    // pre: d is a valid drawing window
    // post: the circle is drawn on the drawing window
    {
	d.drawCircle(left,top,width/2);
    }

    /**
     * post: returns suitable hash code<br>
     * 
     * @return 
     */
    public int hashCode()
    // post: returns suitable hash code
    {
	return left+top+width+height;
    }

    /**
     * post: returns true if two rects are equal<br>
     * 
     * @param other 
     * @return 
     */
    public boolean equals(Object other)
    // post: returns true if two rects are equal
    {
	Circle that = (Circle)other;
	return (this.left == that.left) &&
	       (this.top == that.top) &&
	       (this.width == that.width) &&
	       (this.height == that.height);
    }

    /**
     * post: returns a distinct copy of the Object<br>
     * 
     * @return 
     */
    public Object clone()
    // post: returns a distinct copy of the Object
    {
	return new Circle(this);
    }

    /**
     * post: returns a string representation of Object<br>
     * 
     * @return 
     */
    public String toString()
    // post: returns a string representation of Object
    {
	return "<Circle: left="+left+" top="+top+" width="+width+" height="+height+">";
    }
}
