import element.*;

public class sieve extends Thread
{
    private static final int max = 10000;
    private int fact;
    private sieve nextSieve;

    private boolean inputValid;
    private int input;

    public sieve()
    {
        inputValid = false;
    }

    synchronized public int receive()
    {
        while (!inputValid) 
        {
            try
            {
                wait();
            } catch (Exception e) { System.exit(0); }
        } 
        int result = input;
        inputValid = false;
        notify();
        return result;
    }

    synchronized public void send(int n)
    {
        while (inputValid)
        {
            try
            {
                wait();
            } catch (Exception e) { System.exit(0); }
        }
        input = n;
        inputValid = true;
        notify();
    }

    public void run()
    {
        fact = receive();
        System.out.println(fact);
        int n;
        nextSieve = new sieve();
        nextSieve.setPriority(Thread.NORM_PRIORITY-1);
        nextSieve.start();
        for (n = receive(); n < max; n = receive())
        {
            if (0 != n % fact) nextSieve.send(n);
        }
    }

    public static void main(String args[])
    {
        sieve source = new sieve();
        source.setPriority(Thread.NORM_PRIORITY-1);
        source.start();
        int i;
        for (i = 2; i < max; i++)
        {
            source.send(i);
        }
    }
}
