/*
 * Support for generating mandelbrot images.
 * A good area to start investigation is
 *    (x0,top) = (-2.0,-2.0), rw = rh = 4.0
 * (c) 1993 duane a. bailey
 */
public class Mandelbrot
{
    static int man(double re, double im)
    // pre: computes man(re+im*i)
    {
        double re0 = re, im0 = im;
        double r2,i2;
        int count;
        for (count = 0; count < 255; count++) {
            r2 = re * re; i2 = im * im; /* square (im,re) */
            if (r2 + i2 > 4.0) break; /* halt if magnitude > 2 */
            im = 2 * im * re + im0;     /* add (im,re) to square */
            re = r2 - i2 + re0;
        }
        return 255-count; /* count: 255=> converges, 0=> diverges fast */
    }
}
