import element.*;
import java.awt.Color;

public class juliaThread extends Thread
{
    final static int WIDTH = 200;
    final static int HEIGHT = 200;
    DrawingWindow d;
    static ConsoleWindow c;
    static double x0,y0,w,h;
    static double mu_re, mu_im;

    public void drawJulia(double x0, double y0, double w, double h,
                                 int col, int row, int iw, int ih)
    {
        int r, c;
        d.hold();
        for (r = 0; r < ih; r++)
        {
            for (c = 0; c < iw; c++)
            {
                double x;
                double y;
                x = x0+c*(w/iw);
                y = y0+r*(h/ih);
                int p = Fractal.julia(x,y,mu_re,mu_im);
                if (p < 0) p = 0;
                if (p > 255) p = 255;
                d.setForeground(new Color(p,p,p));
                d.draw(new Pt(col+c,row+r));
            }
            if ((r%5) == 0) { d.release(); d.hold();}
        }
        d.release();
    }

    public Rect scan()
    {
        Pt p = d.awaitMousePress();
        Pt q = p;
        Pt q0;
        Rect r = new Rect(p,q);
        d.setForeground(Color.black);
        d.invertMode();
        d.draw(r);
        while (d.mousePressed())
        {
            q0 = d.getMouse();
            if (!q0.equals(q))
            {
                d.draw(r);
                q = q0;
                r = new Rect(p,q);
                d.draw(r);
            }
        }
        d.draw(r);
        if (r.width() == 0) return null;
        else return r;
    }

    public static void main(String args[])
        {
            juliaThread t = new juliaThread();
            c =new ConsoleWindow(); 
            c.out.println("Suggested inputs: -.75 0 -2 -2 4 4");
            mu_re = c.input.readDouble();
            mu_im = c.input.readDouble();
            x0 = c.input.readDouble();
            y0 = c.input.readDouble();
            w = c.input.readDouble();
            h = c.input.readDouble();
            t.setPriority(Thread.NORM_PRIORITY-1);
            t.start();
        }
    public void run()
    {
        d = new DrawingWindow(WIDTH,HEIGHT);
        double cx0,cy0,cw,ch;
        cx0 = x0;
        cy0 = y0;
        cw = w;
        ch = h;
        c.out.println("Picture is ("+cx0+","+cy0+") "+cw+"x"+ch);
        d.clear(d.bounds());
        long startTime = System.currentTimeMillis();
        drawJulia(cx0,cy0,cw,ch,0,0,WIDTH,HEIGHT);
        c.out.println("Image time="+(double)(System.currentTimeMillis()-startTime)/1000.0+" seconds");
        while (true)
        {
            c.out.println("Scan new rectangle");
            Rect r = scan();
            x0 = cx0 + cw/(double)WIDTH*(double)r.left();
            y0 = cy0 + ch/(double)HEIGHT*(double)r.top();
            w = cw * (double)r.width()/(double)WIDTH;
            h = ch * (double)r.height()/(double)HEIGHT;
            juliaThread t = new juliaThread();
            t.setPriority(NORM_PRIORITY-1);
            t.start();
        }
    }
}
