import element.*;
import java.awt.Color;

public class MandelThread extends Thread
{
    final static int WIDTH = 200;
    final static int HEIGHT = 200;
    DrawingWindow d;
    static ConsoleWindow c;
    static double x0,y0,w,h;

    public void drawMandelbrot(double x0, double y0, double w, double h,
                                 int col, int row, int iw, int ih)
    // pre: (x0,y0) is lower left corner of complex plane
    //      w,h > 0 determine width of image in complex plane
    //      (row,col) is upper left corner of drawing window
    //      iw, ih determine the width and height of the image in window
    {
        int r, c;
        for (r = 0; r < ih; r++)
        {
            d.hold();           // stop updating screen
            for (c = 0; c < iw; c++)
            {
                double x;
                double y;
                // determine the speed and color of this pixel
                x = x0+c*(w/iw);
                y = y0+r*(h/ih);
                int speed = Fractal.mandelbrot(x,y);
                d.setForeground(new Color(speed,speed,speed));
                // draw it!
                d.draw(new Pt(col+c,row+r));
            }
            d.release();        // update entire row
        }
    }

    public Rect scan()
    // post: returns a rectangle drawn out in the dedicated drawing window
    {
        Pt p = d.awaitMousePress();
        Pt q = p;
        Pt q0;
        Rect r = new Rect(p,q);
        d.setForeground(Color.black);
        d.invertMode();
        d.draw(r);
        while (d.mousePressed())
        {
            q0 = d.getMouse();
            if (!q0.equals(q))
            {
                d.draw(r);
                q = q0;
                r = new Rect(p,q);
                d.draw(r);
            }
        }
        d.draw(r);
        if (r.width() == 0) return null;
        else return r;
    }

    public static void main(String args[])
    {
        MandelThread t = new MandelThread();
        c =new ConsoleWindow(); 
        c.out.println("Suggested inputs: -2 -2 4 4");
        x0 = c.input.readDouble();
        y0 = c.input.readDouble();
        w = c.input.readDouble();
        h = c.input.readDouble();
        t.setPriority(Thread.NORM_PRIORITY-1);
        t.start();
    }

    public void run()
    // pre: x0, y0, w, h describe an image region in complex plane
    // post: draw mandelbrot image and generate refined images
    {
        d = new DrawingWindow(WIDTH,HEIGHT);
        double cx0,cy0,cw,ch;
        // copy the starting coordinates from static variables
        cx0 = x0;
        cy0 = y0;
        cw = w;
        ch = h;
        c.out.println("Picture is ("+cx0+","+cy0+") "+cw+"x"+ch);
        d.clear(d.bounds());
        drawMandelbrot(cx0,cy0,cw,ch,0,0,WIDTH,HEIGHT);
        while (true)
        {
            c.out.println("Scan new rectangle");
            Rect r = scan();  // simple: returns scanned rect
            // compute new complex plane coordinates
            x0 = cx0 + cw/(double)WIDTH*(double)r.left();
            y0 = cy0 + ch/(double)HEIGHT*(double)r.top();
            w = cw * (double)r.width()/(double)WIDTH;
            h = ch * (double)r.height()/(double)HEIGHT;
            // create and start new mandelbrot thread
            MandelThread t = new MandelThread();
            t.setPriority(NORM_PRIORITY-1);
            t.start();
        }
    }
}
