import element.*;

public class WordList
{
    private Word[] words;       // words is an array of word objects
    private int entries;        // a count of the number of entries

    public WordList()
    // post: construct a new word list
    {
        words = new Word[1000];
        entries = 0;
    }

    private int locate(String s)
    // pre: s is non-null
    // post: return location of word s in array, or empty slot
    {
        int i;
        for (i = 0; i < entries; i++)
        {
            if (words[i].equals(s)) return i;
        }
        return i;
    }

    public void add(String w)
    // pre: w is non-null, room for a word in list
    // post: w has been added to the list
    {
        int location = locate(w);
        if (location >= entries)
        {
            // add word to array
            words[location] = new Word(w);
            entries = location+1;
        } else {
            words[location].encounter();
        }
    }

    public String toString()
    // post: return a string representation of word list
    {
        String s;
        int i; 
        s = "Word list has "+entries+" entries: \n";
        for (i = 0; i < entries; i++)
        {
            s = s + words[i] + "\n";
        }
        return s;
    }
}
