import element.*;

public class Square extends Rect
{
    private Square()
    // post: constructs a trivial square
    {
        this(0,0,0);
    }

    public Square(Square other)
    // pre: other is non-null
    // post: construct a square, based on another drawable object
    {
        this(other.left(),other.top(),other.width());
    }

    public Square(int left, int top, int d)
    // pre: d >= 0
    // post: constructs a diameter d square with (left,top) corner
    {
        super(left,top,d,d);
    }

    public void width(int w)
    // pre: w >= 0
    // post: sets width and height of square;
    //       center and height remain unchanged
    {
        super.width(w);
        super.height(w);
    }

    public void height(int h)
    // pre: h >= 0
    // post: sets the height of the square;
    //       center and width remain unchanged
    {
        width(h);
    }

    public void extend(int dx, int dy)
    // pre: dx == dy
    // post: extends sides of square out by dx (== dy)
    {
        super.extend(dx,dx);
    }

    public String toString()
    // post: returns a string representation of this square
    {
        return "<Square: left="+left+" top="+top+" diameter="+width+">";
    }
}
