import element.*;
import java.util.Vector;

public class News
{
    static DrawingWindow d;
    static ConsoleWindow c;

    public static void drawButtons(Vector buttons)
    // pre: buttons is non-null
    // post: labels (and associated buttons) are drawn on the screen
    {
        final int width = 40, height = 15;
        final int spacing = 5;

        // the template
        Rect template = new Rect(10, 10, width, height);
        Button b;

        b = new Button(d,template,"all");
        buttons.addElement(b);
        template.move(0, height+spacing);
        b = new Button(d,template,"fits");
        buttons.addElement(b);
        template.move(0, height+spacing);
        b = new Button(d,template,"news");
        buttons.addElement(b);
        template.move(0, height+spacing);
        b = new Button(d,template,"print");
        buttons.addElement(b);
        template.move(0, height+spacing);
        b = new Button(d,template,"that");
        buttons.addElement(b);
        template.move(0, height+spacing);
        b = new Button(d,template,"the");
        buttons.addElement(b);
        template.move(0, height+spacing);
        b = new Button(d,template,"stop");
        buttons.addElement(b);
    }

    public static String selectButton(Vector buttons)
    // pre: buttons drawn on screen
    // post: the label of the first button pressed is returned
    {
        int i;
        Pt p;

        p = d.awaitMousePress();
        d.awaitMouseRelease();
        for (i = 0; i < buttons.size(); i++)
        {
            Button b = (Button)buttons.elementAt(i);
            if (b.contains(p)) return b.label();
        }
        return selectButton(buttons);
    }

    public static void main(String args[])
    {
        d = new DrawingWindow();
        c = new ConsoleWindow();
        Vector buttons = new Vector();
        String s;

        drawButtons(buttons);
        while (true)
        {
            s = selectButton(buttons);
            if (s.equals("stop")) break;
            c.out.print(s+" "); c.out.flush();
        }
        c.out.println();
        System.exit(0);
    }
}
/*
print all the news that fits the print stop
 */
