import java.util.Random;
import element.*;
public class Die
{
    private int faces;          // shape of die
    private int faceValue;      // current value of die
    
    public Die(int n)
    // pre: n >= 1
    // post: construct a randomly oriented die with n faces
    {
        faces = n;
        /*
          the following is similar to:
          this.roll();
        */
        roll();
    }
    
    public Die()
    // post: construct a randomly oriented die with 6 faces
    {
        this(6);
    }

    public void roll()
    // post: re-select the upward-pointing face
    {
        Random rand = new Random();
        faceValue = 1+(Math.abs(rand.nextInt())%faces);
    }

    public int value()
    // post: return the current value of the die
    {
        return faceValue;
    }
}
