import element.*;

public class Button
{
    DrawingWindow targetWindow; // the window containing the button
    Rect activeArea;            // the area we can press w/mouse
    Text label;                 // the label on the area

    public Button(DrawingWindow d, Rect r, String l)
    // pre: d,r,l non-null; l.width <= r.width
    // post: button with text l is created (though not displayed)
    {
        targetWindow = d;
        activeArea = new Rect(r);
        label = new Text(l);
        label.center(r.center());
        targetWindow.draw(activeArea);
        targetWindow.draw(label);
    }

    public boolean contains(Pt p)
    // post: returns true iff p within the button
    {
        return activeArea.contains(p);
    }
}

