import element.*;
import java.util.Random;

public class BeatTheSquares
{
    public static void main(String args[])
    {
        final int gameTime = 60 * 1000; // one minute game
        final int winSize = 300;        // 300x300 window
        final int targetTime = 1000;    // 1000 msec (1 sec) targets
        final int minDiam = 5;          // smallest target
        final int maxDiam = 50;         // largest target
        final int diamRange = maxDiam-minDiam;
        DrawingWindow d = new DrawingWindow(winSize,winSize);
        long endTime;           // time game ends
        Random rand = new Random();
        int score = 0;

        d.invertMode();         // animation painting
        endTime = System.currentTimeMillis()+gameTime;

        while (endTime > System.currentTimeMillis())
        {
            // pick random square, keep on screen for short time
            long targetEndTime =
                      System.currentTimeMillis()+targetTime;
            int dia = (Math.abs(rand.nextInt()))%diamRange + minDiam;
            int x = (Math.abs(rand.nextInt()))%(winSize-dia);
            int y = (Math.abs(rand.nextInt()))%(winSize-dia);
            Square target = new Square(x,y,dia);
            boolean hit = false; // turns true if mouse hits square

            d.draw(target);     // draw target
            while (targetEndTime > System.currentTimeMillis()
                   && !hit)
            {
                // constantly check for mouse down in square
                if (d.mousePressed() 
                    && target.contains(d.getMouse()))
                {
                    score += target.width()*target.width();
                    hit = true;
                    d.awaitMouseRelease();
                }
            }
            d.draw(target);     // erase (invert) target
        }
        d.draw(new Text("Your score: "+score,50,150));
    }
}
