import element.*;
import java.util.Vector;
public class Insertion
{
    public static void swap(Vector list, int index1, int index2)
    // pre: index1, index2 < list.size()
    // post: values at locations index1 and index2 are swapped in list
    {
        String value1 = (String)list.elementAt(index1);
        String value2 = (String)list.elementAt(index2);
        list.setElementAt(value2,index1);
        list.setElementAt(value1,index2);
    }

    public static void Sort(Vector list, int number)
    // pre: number <= list.size()
    // post: elements 0..number-1 of the Vector are sorted
    {
        String one, other, small, big;
        int location;
        if (number > 1)
        {
            Sort(list,number-1);  // sort most of the list, recursively
            // now, we must only insert list.elementAt(number-1)
            // in among the first number-1 elements, which are sorted:
            location = number-1;
            while (location > 0)
            {
                big = (String)list.elementAt(location);
                small = (String)list.elementAt(location-1);
                if (big.compareTo(small) < 0) // they're out of order
                {
                    swap(list,location-1,location);
                    location--;
                } else {
                    break;
                }
            }
        }
    }

    public static void Sort(Vector list)
    // pre: list is non-null vector of strings
    // post: elements of list are sorted into increasing order
    {
        Sort(list,list.size());
    }

    public static void main(String args[])
    {
        ConsoleWindow c = new ConsoleWindow();
        int i;
        Vector data = new Vector();

        while (!c.input.eof()) // while we haven't hit end of input
        {
            data.addElement(c.input.readLine()); // add lines to list
        }
        Sort(data);            // sort them
        c.out.println(data);   // print them
        System.exit(0);
    }
}
/*
*/

