import element.*;

public class Recursion
{
    static DrawingWindow d;
    public static void main(String args[])
    {
        int i;
        System.out.println("\"");
        for (i = 0; i < args.length; i++) {
            System.out.println(lowerString(args[i]));
        }

        for (i = 0; i < args.length; i++) {
            System.out.println(reverse(args[i]));
        }

        System.out.println(reverse("yaw way "));
        d = new DrawingWindow();

        Pt      p;
        //      d.invertMode();
        while (true) { 
            p = d.awaitMousePress();
            drawLine(100,100,p.x(), p.y());
            d.drawLine(100,150,p.x(),p.y()+50);
            d.awaitMouseRelease();
            d.clear(d.bounds());
            //      drawLine(100,100,p.x(), p.y());
            //      d.drawLine(100,150,p.x(),p.y()+50);
        }
    }

    public static void drawLine(int x0, int y0, int x1, int y1)
    // pre: drawing window d is non-null
    // post: a line is drawn on d from (x0,y0) to (x1,y1)
    {
        int mx = (x0+x1)/2;             // midpoint
        int my = (y0+y1)/2;
        int dx = Math.abs(x1-x0);       // span in x and y direction
        int dy = Math.abs(y1-y0);
        if (dx <= 1 && dy <= 1)  // very close endpoints
        {
            d.draw(new Pt(x1,y1));      // draw destination
        } else if (dx > 1 || dy > 1)
        {
            drawLine(x0,y0,mx,my);      // draw first half
            drawLine(mx,my,x1,y1);      //    and second half
        }
    }

    public static String reverse(String s)
    // pre: s is non-null
    // post: returns the reverse of s
    {
        char c;
        String rest;
        if (!s.equals(""))
        {
            c = s.charAt(0); // must be at least one character
            rest = s.substring(1);
            s = reverse(rest)+c;
        }
        return s;
    }

    public static String lowerString(String s)
    // pre: s is non-null
    // post: s is converted to lowercase
    {
        char c;
        String rest;
        if (s.equals(""))
        {
            return s;
        } else {
            // break the problem apart
            c = s.charAt(0);
            rest = s.substring(1);
            // solve and glue back together
            return toLower(c)+lowerString(rest);
        } 
    }


    public static char toLower(char c)
    // post: if c is an uppercase letter, it is converted to lowercase
    //       otherwise, c is returned untouched.
    {
        if (isUpper(c))
        {
            return (char)((int)c - (int)'A' + (int)'a');
        } else {
            return c;
        }
    }

    public static boolean isLower(char c)
    // pre: returns true if c is a lower case letter
    {
        return ('a' <= c) && (c <= 'z');
    }

    public static boolean between(char a, char b, char c)
    // pre: returns true if a <= b <= c as a character
    {
        return (a <= b) && (b <= c);
    }

    public static boolean isUpper(char c)
    // post: return true if c is an uppercase letter
    {
        return between('A',c,'Z');
    }
}

