import element.*;

public class Hanoi
{
    static ConsoleWindow c;
    public static void main(String[] args)
    // post: solve the n disk tower of hanoi problem
    {
        c = new ConsoleWindow();
        int n = c.input.readInt();
        hanoi(n,"left","right","middle");
    }

    public static void hanoi(int n,
             String source, String destination, String extra)
    // pre: n > 0, source, destination, and extra are distinct
    // post: n disks are moved from source to destination
    {
        if (n == 1)
        {
            c.out.println("Move disk from "+source+
                          " to "+destination);
        } else {
            hanoi(n-1,source,extra,destination);
            hanoi(1,source,destination,extra);
            hanoi(n-1,extra,destination,source);
        }
    }
}
/*
Move disk from left to right
Move disk from left to middle
Move disk from right to middle
Move disk from left to right
Move disk from middle to left
Move disk from middle to right
Move disk from left to right
*/
