import element.*;

public class StringOps
{
    public static void main(String args[])
    {
        
        DrawingWindow d = new DrawingWindow();
        ConsoleWindow c = new ConsoleWindow();
        String s;

        c.out.println("rest" + "rain"); // prints "restrain"

        String first = "sure";
        String second = "plea";
        String combined = second+first;

        c.out.print(first+" ");
        c.out.print(second+":");
        c.out.println(" "+combined);
        

        /*      c.out.println("Press mouse in drawing window.");
                d.awaitMousePress();*/
        Pt origin = new Pt(0,0);
        Pt mouse = d.getMouse();
        // generate a line (segment) from the origin to the mouse
        Line segment = new Line(origin,mouse);
        c.out.println(segment);

        String pi = ""+Math.PI; // Math.PI is a double constant
        c.out.println(pi+" is printed in "+pi.length()+" characters");

        
        int n = 78;
        s = "hello";
        while (s.length() < n)
        {
            s = s + "*";        // or, alternatively, s += "*"
        }
        c.out.println(s);
        
        int i;
        s = "HOWDY";
        for (i = 0; i < s.length(); i++)
        {
            c.out.print(s.charAt(i)+" ");
        }
        c.out.println();

        c.out.println("Here are 10 stars:");
        c.out.println(pad("",80,'*'));
        c.out.println(">"+headline("NEWS FLASH!")+"<");
        c.out.println(headline(headline("NEWS FLASH!")));
        c.out.println(headline(headline(headline("NEWS FLASH!"))));
    }
    
    public static String pad(String base, int n, char c)
    // pre: n >= 0, base is non-null
    // post: result is base, padded out to length n with copies of c
    {
        while (base.length() < n)
        {
            base = base + c;
        }
        return base;
    }

    public static String headline(String text)
    // pre: text is a non-null String
    // post: result is text, with a space between original characters
    {
        String result = "";     // result might be empty (why?)
        int i;                  // index of character

        for (i = 0; i < text.length(); i++)
        {
            // collects characters of text, but followed by a space
            result = result + text.charAt(i) + ' ';
        }
        return result;
    }
    
}

/*
restrain
sure plea: pleasure
<Line: (0,0) to (48,93)>
>N E W S   F L A S H ! <
*/
