import element.*;

public class Scans
{
    public static boolean containsSpace(String s)
    // pre: s is non-null
    // post: returns true of there is a space in s
    {
        boolean found = false; // no spaces found...yet
        int i;

        for (i = 0; i < s.length() && !found; i++)
        {
            if (' ' == s.charAt(i)) found = true;  // found a space
        }
        return found;  // true if a space was found, else false
    }

    /* Strings to consider for wordCount:
       ""               // the empty string has 0 words
       "   "            // a string with just spaces has 0 words
       "my word!"       // this string has two words
       "  word "        // this string has one word
     */
    public static int wordCount(String s)
    // pre: s is non-null
    // post: returns the number of space-delimited "words"
    {
        int count = 0;
        boolean wasSpace, nowSpace;   // at beginning, not in a word
        int i;

        wasSpace = true;
        for (i = 0; i < s.length(); i++)
        {
            nowSpace = s.charAt(i) == ' ';

            if (wasSpace && !nowSpace) 
            {
                    count++;
            }
            wasSpace = nowSpace;
        }
        return count;
    }

    public static void main(String args[])
    {
        DrawingWindow d = new DrawingWindow();

        ConsoleWindow c = new ConsoleWindow();
        String s = c.input.readLine();
        if (containsSpace(s)) c.out.println("There was a space.");
        else       c.out.println("There was not a space.");
        c.out.println("line contains "+wordCount(s)+" words");

        c.out.println("A lower case version of string is "+toLower(s));
        c.input.readString();
        System.exit(0);
    }

    public static String toLower(String s)
    // post: the uppercase letters of s are converted to lowercase
    {
        String result = "";
        char c;
        int i;
        for (i = 0; i < s.length(); i++)
        {
            c = s.charAt(i);
            if (isUpper(c)) result += toLower(c);
            else result += c;
        }
        return result;
    }

    public static char toLower(char c)
    // post: if c is an uppercase letter, it is converted to lowercase
    //       otherwise, c is returned untouched.
    {
        if (isUpper(c))
           return (char)((int)c - (int)'A' + (int)'a');
        else 
           return c;
    }

    public static boolean isUpper(char c)
    // post: return true if c is an uppercase letter
    {
        return between('A',c,'Z');
    }

    public static boolean between(char a, char b, char c)
    // pre: returns true if a <= b <= c as a character
    {
        return (a <= b) && (b <= c);
    }
}
