import element.*;

public class Lowerize
{
    public static boolean between(char a, char b, char c)
    // pre: returns true if a <= b <= c as a character
    {
        return (a <= b) && (b <= c);
    }

    public static boolean isUpper(char c)
    // post: return true if c is an uppercase letter
    {
        return between('A',c,'Z');
    }

    public static char toLower(char c)
    // post: if c is an uppercase letter, it is converted to lowercase
    //       otherwise, c is returned untouched.
    {
        if (isUpper(c))
           return (char)((int)c - (int)'A' + (int)'a');
        else 
           return c;
    }

    public static String toLower(String s)
    // pre: s is non-null
    // post: the uppercase letters of s are converted to lowercase
    {
        String result = "";  // here, we'll accumulated the lower string
        char ch;
        int i;

        for (i = 0; i < s.length(); i++)
        {
            ch = s.charAt(i); // for speed, get character once, into ch
            if (isUpper(ch)) ch = toLower(ch); // make uppercase lower
            result += ch;     // append ch onto result
        }
        return result;       // same length as s
    }

    public static void main(String args[])
    {
        ConsoleWindow c = new ConsoleWindow();
        while (!c.input.eof())
        {
            c.out.println(toLower(c.input.readLine()));
        }
        System.exit(0);
    }
}
