import element.*;
import java.util.Random;

public class Cryptogram
{
    static String encoder;      // the cipher
    static String decoder;      // user's guess and encoder inverse
    static String plainText;    // the secret message
    static String message;      // the encripted message
    static String guess;        // user's guess at secret message
    static Random gen;          // random number generator

    public static boolean isUpper(char ch)
    // post: return true iff ch is an upper case letter
    {
        return (('A' <= ch) && (ch <= 'Z'));
    }

    public static int rand(int low, int high)
    // pre: low <= high
    // post: returns random value x, low <= x <= high
    {
        return (Math.abs(gen.nextInt()) % (high-low+1))+low;
    }

    public static String setCharAt(String s, int i, char c)
    // pre: s is non-null, 0 <= i < s.length()
    // post: returns string s with char at i set to c
    {
        String prefix = s.substring(0,i); // part of string before i
        String suffix = s.substring(i+1); // part of string after i
        return prefix + c + suffix;
    }

    public static String shuffle(String source)
    // pre: source is non-null
    // post: shuffles the characters of source
    {
        int i;
        int dest;
        char sc, dc;

        // give every character a chance to move to a new destination
        for (i = 0; i < source.length(); i++)
        {
            dest = rand(0,source.length()-1); // pick destination
            sc = source.charAt(i);             // the ith character
            dc = source.charAt(dest);         // the destination char
            source = setCharAt(source,i,dc);   // swap two
            source = setCharAt(source,dest,sc); // locations
        }
        return source;
    }

    public static String apply(String encoder,String message)
    // pre: encoder is non-null shuffle of alphabet, message non-null
    // post: returns message encoded using cypher suggested by encoder
    {
        int i;
        char c;
        int alphabetCode;
        String result = "";     // the ciphered string
        for (i = 0; i < message.length(); i++)
        {
            c = message.charAt(i);
            if (isUpper(c))     // other characters untouched
            {
                alphabetCode = c-'A';
                // look up c in the encoder string
                c = encoder.charAt(alphabetCode);
            }
            result = result + c;
        }
        return result;
    }

    public static void initialize()
    // post: initializes generator, plaintext, message, decoder and encoder
    {
        char ch;

        gen = new Random();
        gen.setSeed(1960);

        plainText = "JAVA: IN INDONESIA!";

        encoder = "";
        for (ch = 'A'; ch <= 'Z'; ch++)
        {
            encoder = encoder + ch;
        }
        encoder = shuffle(encoder);

        message = apply(encoder,plainText);

        decoder = "";
        for (ch = 'A'; ch <= 'Z'; ch++)
        {
            decoder = decoder + ' ';
        }
    }

    public static void main(String args[])
    {
        ConsoleWindow c = new ConsoleWindow();
        String firstWord;                       // first word on input
        char sourceCh, targetCh;                // coded, uncoded letters

        initialize();                           // encode secret message
        c.out.println("cryptogram="+message);   // print message
        guess = apply(decoder,message);         // generates all spaces
        c.out.println("     guess="+guess);     // decrypted message

        do
        {
            firstWord = c.input.readString();   // read in word
            if (firstWord.equals("QUIT")) {     // to check for QUIT
                break;
            } else {
                sourceCh = firstWord.charAt(0); // get characters
                targetCh = c.input.readString().charAt(0);
                c.out.println(sourceCh+" is substituted with "+targetCh);
                // record user's mapping of characters
                decoder = setCharAt(decoder,sourceCh-'A',targetCh);
                // compute user's decoding of message
                guess = apply(decoder, message);
                c.out.println("cryptogram="+message);
                c.out.println("     guess="+guess);
            }
            // check to see if the message has been guessed
        } while (!guess.equals(plainText));

        // print appropriate finish message
        if (guess.equals(plainText)) {
            c.out.println("You figured it out!");
        } else {
            c.out.println("Better luck next time!");
        }
        System.exit(0);
    }
}
/*
MTVT: KP KPUDPZNKT!
cryptogram=MTVT: KP KPUDPZNKT!
     guess=    :             !
T A
T is substituted with A
cryptogram=MTVT: KP KPUDPZNKT!
     guess= A A:            A!
K I
K is substituted with I
cryptogram=MTVT: KP KPUDPZNKT!
     guess= A A: I  I      IA!
P N
P is substituted with N
cryptogram=MTVT: KP KPUDPZNKT!
     guess= A A: IN IN  N  IA!
QUIT
Better luck next time!
 */
