import element.*;

public class Tools
{
    public static void clearWindow(DrawingWindow target)
    // pre: target is a non-null drawing window
    // post: target is erased
    {
        Rect boundary = target.bounds();
        target.clear(boundary);
    }

    public static void drawPoly(DrawingWindow d,
                                Pt center, double radius, 
                                int n, double degrees)
    // pre: d, center is non-null, radius >= 0, n > 2, 0 <= degrees < 360
    // post: a regular polygon is drawn on d, centered at center
    //       with radius radius and n sides; one point makes angle measuring
    //       degrees with the positive x axis
    {
        double offsetRadians = degrees/180.0*Math.PI;
        double theta;
        int x,y;
        int vertexNumber;

        for (vertexNumber = 0; vertexNumber <= n; vertexNumber++)
        {
            // angle of vertex (initial is offsetRadians)
            theta = 2*Math.PI/n*vertexNumber + offsetRadians;
            // compute location of vertex
            x = (int)Math.round(center.x() + radius*Math.cos(theta));
            y = (int)Math.round(center.y() + radius*Math.sin(theta));
            if (vertexNumber == 0) d.moveTo(x,y);
            else                   d.lineTo(x,y);
        }
    }

    public static void main(String args[])
    {
        DrawingWindow d = new DrawingWindow();
        double theta = 0.0;
        Pt pressPoint;

        clearWindow(d);
        d.invertMode();
        d.draw(d.bounds().center());
        drawPoly(d, d.bounds().center(), 50.0, 5, theta);
        while (!d.mousePressed())
        {
            drawPoly(d, d.bounds().center(), 50.0, 5, theta);
            pressPoint = d.getMouse();
            theta = Math.atan2(pressPoint.y()-d.bounds().center().y(),
                               pressPoint.x()-d.bounds().center().x());
            theta = theta/Math.PI*180;
            drawPoly(d, d.bounds().center(), 50.0, 5, theta);
        }
    }
}
/*
*/

