import element.*;
import java.awt.Color;  // must be imported to include Color

public class Grayscale
{
    public static Color gray(double intensity)
    // pre: 0 <= intensity <= 1.0
    // post: returns a gray with indicated intensity level (1.0=white)
    {
        return new Color((float)intensity,(float)intensity,(float)intensity);
    }

    public static void main(String args[])
    {
        DrawingWindow d = new DrawingWindow();
        d.setForeground(new Color((float)1.0,(float)0.85,(float)0.85));
        d.fill(new Rect(0,0,200,200));
        d.awaitMousePress();
        int i;

        // draw vertical lines, each with a fixed gray color
        // that varies from left (black) to right (white)
        for (i = 0; i < d.bounds().width(); i++)
        {
            d.setForeground(gray(i*1.0/d.bounds().width()));
            d.moveTo(i,0);
            d.lineTo(i,d.bounds().height());
        }
    }
}
/*
*/

