import element.*;

public class Converter
{
    public static char toLower(char c)
    // post: if c is an uppercase letter, it is converted to lowercase;
    //       otherwise, c is returned untouched
    {
        int position;
        if (isUpper(c))
        {
            position = c - 'A';         // position of c in upper case
            c = (char)('a'+position);   // corresponding lower case
        }
        return c;
    }

    public static boolean isLower(char c)
    // post: returns true if c is a lower case letter
    {
        return ('a' <= c) && (c <= 'z');
    }

    public static boolean between(char a, char b, char c)
    // post: returns true if a <= b <= c as a character
    {
        return (a <= b) && (b <= c);
    }

    public static boolean isUpper(char c)
    // post: return true if c is an uppercase letter
    {
        return between('A',c,'Z');
    }

    public static void main(String args[])
    {
        ConsoleWindow c = new ConsoleWindow();
        while (!c.input.eof()) // while there's input
        {
            while (!c.input.eoln()) // for every character on a line
            {
                char ch = c.input.readChar();
                c.out.print(toLower(ch));
            }
            c.input.readln();  // read end-of-line mark
            c.out.println();   // write an end-of-line mark
        }
    }
}
