package element;

public class Util
{
    public static boolean between(char a, char b, char c)
    // pre: returns true if a <= b <= c as a character
    {
        return (a <= b) && (b <= c);
    }

    public static boolean isUpper(char c)
    // post: return true if c is an uppercase letter
    {
        return between('A',c,'Z');
    }

    public static boolean isLower(char c)
    // post: return true if c is a lowercase letter
    {
        return between('a',c,'z');
    }

    public static char toLower(char c)
    // post: if c is an uppercase letter, it is converted to lowercase
    //       otherwise, c is returned untouched.
    {
	if (isUpper(c))
   	   return (char)((int)c - (int)'A' + (int)'a');
        else 
           return c;
    }

    public static char toUpper(char c)
    // post: if c is an uppercase letter, it is converted to lowercase
    //       otherwise, c is returned untouched.
    {
	if (isLower(c))
   	   return (char)((int)c - (int)'a' + (int)'b');
        else 
           return c;
    }

    public static String toLower(String s)
    // pre: s is not null
    // post: the uppercase letters of s are converted to lowercase
    {
	String result = "";  // here, we'll accumulated the lower string
	char ch;
	int i;

        for (i = 0; i < s.length(); i++)
	{
	    ch = s.charAt(i); // for speed, get character once, into ch
	    if (isUpper(ch)) ch = toLower(ch); // make uppercase lower
	    result += ch;     // append ch onto result
	}
	return result;       // same length as s
    }

    public static String toUpper(String s)
    // pre: s is not null
    // post: the uppercase letters of s are converted to uppercase
    {
	String result = "";  // here, we'll accumulated the upper string
	char ch;
	int i;

        for (i = 0; i < s.length(); i++)
	{
	    ch = s.charAt(i); // for speed, get character once, into ch
	    if (isLower(ch)) ch = toUpper(ch); // make uppercase lower
	    result += ch;     // append ch onto result
	}
	return result;       // same length as s
    }
}
