// The console package (c) 1997 duane a. bailey and lyle a. mcgeoch
// The public class supporting input from the keyboard and output to a window.
package element;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import structure.ReadStream;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: ConsoleWindow.java,v 2.2 1999/08/05 16:18:01 bailey Exp bailey $
 * @author duane a. bailey
 */
public class ConsoleWindow
{
    Container theContainer;
    ConsoleCanvas area;
    ConsoleScrollbar rowScroller;
    ConsoleScrollbar colScroller;
    public PrintWriter out;   // the output stream
    public InputStream in;    // the input stream
    public ReadStream input;  // the input ReadStream
    Thread mainThread;
    /*
     MenuBar mb;
    */
	
    /**
     */
    public ConsoleWindow()
    // post: constructs a 24x80 console window
    {
	this(24,80,"Console Window");
    }

    public ConsoleWindow(Container c)
    {
	this(24,80,"Console Window",new Font("Courier", Font.PLAIN, 10),c);
    }
	
    public ConsoleWindow(int rows, int cols, String name)
    // post: constructs a rows by cols window titled name
    {
	this(rows, cols, name, new Font("Courier", Font.PLAIN, 10), null);
    }

    /**
     * @param theFont 
     */
    public ConsoleWindow(int rows, int cols, String name, Font theFont, Container c)
    // post: constructs a rows by cols window titled name,
    //       using theFont to display itself in Container c
    {
	if (null == System.getProperty("stdio"))
	{
	    Frame f = null;
	    if (c == null)
	    {
		f = new Frame();
		f.setTitle(name);
		f.setResizable(true);
		c = f;
	    }
    		
	    mainThread = Thread.currentThread();
	    c.setLayout(new BorderLayout());
	    c.setBackground(Color.white);
	    c.setForeground(Color.black);
	    c.setFont(theFont);
	    /* This should wait until we're further along
	       mb = new MenuBar();
	       setMenuBar(mb);
	       Menu m = new Menu("Actions");
	       mb.add(m);
	       MenuItem eof;
	       m.add(new MenuItem("Send EOF",new MenuShortcut(KeyEvent.VK_D)));
	       */
		
	    area = new ConsoleCanvas(rows, cols, theFont);
	    rowScroller = new ConsoleScrollbar(Scrollbar.VERTICAL,area);
	    colScroller = new ConsoleScrollbar(Scrollbar.HORIZONTAL,area);
	    area.setScrollbar(rowScroller,colScroller);

	    out = new PrintWriter(new ConsoleOutput(area),true);
	    in  = new ConsoleKeyboard(area);
	    input = new ReadStream(in);

	    c.add("Center", area);
	    c.add("East", rowScroller);
	    c.add("South", colScroller);
	    if (f != null)
	    {
		f.pack();
		f.setVisible(true);
	    }
	    area.requestFocus();
	    theContainer = c;
	} else {
	    out = new PrintWriter(System.out,true);
	    in = System.in;
	    input = new ReadStream(in);
	}
    }

    public String toString()
    // post: constructs a string describing the window
    {
	return "<Console Window>";
    }
}	
