// The console package (c) 1997 duane a. bailey and lyle a. mcgeoch
// The class supporting scrollbars for the console.
package element;

import java.awt.*;
import java.awt.event.*;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: ConsoleScrollbar.java,v 2.1 1999/07/11 02:52:16 bailey Exp $
 * @author duane a. bailey
 */
class ConsoleScrollbar extends Scrollbar
      implements AdjustmentListener
{
    protected ConsoleCanvas theCanvas; // the associated canvas
    protected int rows;		// number of rows in window
    protected int lineCount;	// number of lines in logical window
    protected int pageSize;	// number of lines in scroll-down amount
    protected int currentValue;

    ConsoleScrollbar(int direction, ConsoleCanvas theCanv)
    {
	// a vertical scrollbar
	// initial value of 0
	// displaying theCanvas.rows() rows
	// data range is between 0 and 0
	super(direction);
	theCanvas = theCanv;
	rows = (direction==VERTICAL)?theCanvas.rows():theCanvas.cols();
	pageSize = rows;
	lineCount = rows;
	addAdjustmentListener(this);
	setValues(0,pageSize,0,lineCount);
    }

    synchronized	
    void expandTo(int value)
    {
	int currentValue = getValue();
	if (value > lineCount)
	{
	    if (currentValue >= (lineCount-1))
	    {
		currentValue = value-1;
	    }
	    lineCount = value;
	    setValues(currentValue,pageSize,0,lineCount);
	}
	if ((value <= currentValue) || (value >= currentValue+pageSize)) {
	    setValues(value-1,pageSize,0,lineCount);
	}
    }
    
    synchronized
    void scrollMaximum()
    {
	setValues(lineCount-1,pageSize,0,lineCount);
    }
  
    synchronized
    void scrollMinimum()
    {
	setValues(0,pageSize,0,lineCount);
    }
  
    /**
     * @param e 
     */
    public void adjustmentValueChanged(AdjustmentEvent e)
    {
	theCanvas.repaint();
    }
}
