// The console package (c) 1997 duane a. bailey and lyle a. mcgeoch
// The class supporting out stream output to window
package element;

import java.io.*;

/**
 * Copyright (c) 1997 McGraw-Hill
 * All Rights Reserved.
 * <p>
 * Permission to use, copy, modify, and distribute this
 * software and its documentation for NON-COMMERCIAL purposes
 * and without fee is hereby granted provided that this
 * copyright notice appears in all copies. Please refer to
 * the file <a href="http://www.cs.williams.edu">"copyright.html"</a> for further important copyright
 * and licensing information.
 * <p>
 * MCGRAW-HILL MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE
 * SUITABILITY OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 * NON-INFRINGEMENT. MCGRAW-HILL SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 * @version $Id: ConsoleOutput.java,v 2.1 1999/07/11 02:52:16 bailey Exp $
 * @author duane a. bailey
 */
class ConsoleOutput extends OutputStream
{
    protected ConsoleCanvas canvas;
	
    ConsoleOutput (ConsoleCanvas canvas) {
	this.canvas = canvas;
    }
	
    public void write (int b) {
	canvas.append ((byte) b);
    }

    /**
     * @param data 
     * @param start 
     * @param length 
     */
    public void write(byte[] data, int start, int length)
    {
	for (int i = 0; i < length; i++)
	{
	    canvas.append((byte)data[start+i]);
	}
    }

    /**
     */
    public void flush()
    {
	return;
    }

    /**
     */
    public void close()
    {
	// DAB
	return;
    }
}
