/*
 * Decompiled with CFR 0.152.
 */
package structure;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import structure.Assert;

public class ReadStream
extends FilterInputStream {
    protected DataInputStream strm = (DataInputStream)this.in;
    protected boolean atEOF = false;
    protected char[] buffer = new char[8];
    protected int buffersize = 8;
    protected int buffertop = -1;
    protected boolean absorbNL = false;

    public ReadStream() {
        this(System.in);
    }

    public ReadStream(InputStream inputStream) {
        super(new DataInputStream(inputStream));
    }

    private boolean acceptChar(char c) {
        char c2 = this.readChar();
        if (Character.toLowerCase(c) == Character.toLowerCase(c2)) {
            return true;
        }
        this.pushbackChar(c2);
        return false;
    }

    private boolean acceptWord(String string) {
        this.skipWhite();
        int n = 0;
        while (n < string.length()) {
            if (!this.acceptChar(string.charAt(n))) {
                int n2 = n - 1;
                while (n2 >= 0) {
                    this.pushbackChar(string.charAt(n2));
                    --n2;
                }
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean eof() {
        if (this.atEOF) {
            return true;
        }
        this.peek();
        return this.atEOF;
    }

    public boolean eoln() {
        char c = this.peek();
        return this.eof() || c == '\n' || c == '\r';
    }

    private static boolean isWhite(char c) {
        return Character.isWhitespace(c);
    }

    public char peek() {
        char c = this.readChar();
        this.pushbackChar(c);
        return c;
    }

    public void pushbackChar(char c) {
        if (c == '\u0000') {
            return;
        }
        this.atEOF = false;
        ++this.buffertop;
        if (this.buffertop == this.buffersize) {
            char[] cArray = this.buffer;
            this.buffersize *= 2;
            this.buffer = new char[this.buffersize];
            int n = 0;
            while (n < this.buffertop) {
                this.buffer[n] = cArray[n];
                ++n;
            }
        }
        this.buffer[this.buffertop] = c;
        this.absorbNL = false;
    }

    public boolean readBoolean() {
        if (this.acceptWord("true")) {
            return true;
        }
        if (!this.acceptWord("false")) {
            Assert.fail("Boolean not found on input.");
        }
        return false;
    }

    public char readChar() {
        char c;
        block8: {
            c = '\u0000';
            try {
                try {
                    if (this.atEOF) {
                        break block8;
                    }
                    if (this.buffertop >= 0) {
                        c = this.buffer[this.buffertop--];
                        break block8;
                    }
                    c = (char)this.strm.readByte();
                }
                catch (EOFException eOFException) {
                    this.atEOF = true;
                }
                catch (IOException iOException) {
                    Assert.fail("Input error free.");
                }
            }
            catch (Throwable throwable) {}
        }
        if (this.absorbNL && c == '\n') {
            this.absorbNL = false;
            c = this.readChar();
        }
        this.absorbNL = c == '\r';
        return c;
    }

    public double readDouble() {
        StringBuffer stringBuffer = new StringBuffer();
        this.skipWhite();
        if (this.acceptChar('+')) {
            stringBuffer.append('+');
        } else if (this.acceptChar('-')) {
            stringBuffer.append('-');
        }
        char c = this.readChar();
        while (Character.isDigit(c)) {
            stringBuffer.append(c);
            c = this.readChar();
        }
        this.pushbackChar(c);
        if (this.acceptChar('.')) {
            stringBuffer.append('.');
            c = this.readChar();
            while (Character.isDigit(c)) {
                stringBuffer.append(c);
                c = this.readChar();
            }
            this.pushbackChar(c);
        }
        if (this.acceptChar('E')) {
            stringBuffer.append('E');
            if (this.acceptChar('+')) {
                stringBuffer.append('+');
            } else if (this.acceptChar('-')) {
                stringBuffer.append('-');
            }
            c = this.readChar();
            while (Character.isDigit(c)) {
                stringBuffer.append(c);
                c = this.readChar();
            }
            this.pushbackChar(c);
        }
        String string = stringBuffer.toString();
        return Double.valueOf(string);
    }

    public float readFloat() {
        return (float)this.readDouble();
    }

    public void readFully(byte[] byArray) throws IOException {
        this.strm.readFully(byArray);
    }

    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.strm.readFully(byArray, n, n2);
    }

    public int readInt() {
        return (int)this.readLong();
    }

    public String readLine() {
        StringBuffer stringBuffer = new StringBuffer();
        while (!this.eoln()) {
            stringBuffer.append(this.readChar());
        }
        this.readChar();
        return stringBuffer.toString();
    }

    public long readLong() {
        boolean bl = false;
        int n = 0;
        long l = 0L;
        int n2 = 10;
        this.skipWhite();
        if (this.eof()) {
            return 0L;
        }
        while (!this.eof()) {
            char c = this.readChar();
            if (n == 0 && c == '-') {
                bl = true;
                continue;
            }
            if (n == 0 && c == '0') {
                n2 = 8;
                ++n;
                continue;
            }
            if (n == 1 && n2 == 8 && (c == 'x' || c == 'X')) {
                n2 = 16;
                ++n;
                continue;
            }
            int n3 = c - 48;
            if (c >= 'a' && c <= 'f') {
                n3 = c - 97 + 10;
            } else if (c >= 'A' && c <= 'F') {
                n3 = c - 65 + 10;
            }
            if (n3 < 0 || n3 >= n2) {
                this.pushbackChar(c);
                break;
            }
            ++n;
            l = l * (long)n2 + (long)n3;
        }
        if (bl) {
            l = -l;
        }
        return l;
    }

    public short readShort() {
        return (short)this.readLong();
    }

    public String readString() {
        char[] cArray = new char[512];
        char c = '\u0000';
        int n = 0;
        this.skipWhite();
        while (!this.eof()) {
            c = this.readChar();
            if (ReadStream.isWhite(c)) {
                this.pushbackChar(c);
                break;
            }
            cArray[n++] = c;
        }
        return new String(cArray, 0, n);
    }

    public String readUTF() throws IOException {
        return this.strm.readUTF();
    }

    public void readln() {
        this.readLine();
    }

    public void skipWhite() {
        char c = this.readChar();
        while (ReadStream.isWhite(c)) {
            c = this.readChar();
        }
        this.pushbackChar(c);
    }
}

