/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Drawable;
import element.DrawingWindow;
import element.Line;
import element.Pt;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Text
implements Drawable {
    private int left;
    private int bottom;
    private int width;
    private int height;
    private Font font;
    private FontMetrics fm;
    private String string;
    private static Graphics context;
    private static Font defaultFont;
    private static FontMetrics dfm;

    public Text(char c) {
        this(new Character(c).toString(), 0, 0);
    }

    public Text(long l) {
        this(Long.toString(l), 0, 0);
    }

    public Text(Text text) {
        this.string = text.string;
        this.left = text.left;
        this.bottom = text.bottom;
        this.font = text.font;
        this.fm = text.fm;
        this.width = text.width;
        this.height = text.height;
    }

    public Text(Object object) {
        this(object, 0, 0);
    }

    public Text(Object object, int n, int n2) {
        this(object.toString(), n, n2);
    }

    public Text(Object object, Pt pt) {
        this(object, pt.x(), pt.y());
    }

    public Text(String string) {
        this(string, 0, 0);
    }

    public Text(String string, int n, int n2) {
        if (defaultFont == null) {
            defaultFont = new Font("Courier", 0, 12);
            dfm = null;
        }
        this.string = new String(string);
        this.left = n;
        this.bottom = n2;
        this.font = defaultFont;
        this.fm = null;
        this.getDimensions();
    }

    public int bottom() {
        return this.bottom;
    }

    public void bottom(int n) {
        this.bottom = n;
    }

    public Pt center() {
        return new Pt(this.left + this.width() / 2, this.bottom - this.height() / 2);
    }

    public void center(Pt pt) {
        Pt pt2 = this.center();
        this.left(this.left() + (pt.x() - pt2.x()));
        this.top(this.top() + (pt.y() - pt2.y()));
    }

    public void clearOn(DrawingWindow drawingWindow) {
        drawingWindow.clearText(this);
    }

    public Object clone() {
        return new Text(this);
    }

    public boolean contains(Pt pt) {
        return Line.within(pt.x(), this.left, this.width()) && Line.within(pt.y(), this.top(), this.height());
    }

    public void drawOn(DrawingWindow drawingWindow) {
        drawingWindow.drawText(this);
    }

    public boolean equals(Object object) {
        Text text = (Text)object;
        return this.string.equals(text.string) && this.left == text.left && this.bottom == text.bottom;
    }

    public void fillOn(DrawingWindow drawingWindow) {
        drawingWindow.drawText(this);
    }

    public Font font() {
        return this.font;
    }

    private void getDimensions() {
        if (this.height != 0) {
            return;
        }
        if (this.fm == null) {
            if (dfm == null && context == null) {
                if (DrawingWindow.exampleContext == null) {
                    return;
                }
                context = DrawingWindow.exampleContext;
                dfm = context.getFontMetrics(defaultFont);
            }
            this.fm = this.font == defaultFont ? dfm : context.getFontMetrics(this.font);
        }
        this.width = this.fm.stringWidth(this.string);
        this.height = this.fm.getAscent() + this.fm.getDescent();
    }

    public int hashCode() {
        return this.string.hashCode();
    }

    public int height() {
        this.getDimensions();
        return this.height;
    }

    public int left() {
        return this.left;
    }

    public void left(int n) {
        this.left = n;
    }

    public int right() {
        return this.left + this.width();
    }

    public void right(int n) {
        this.left = n - this.width();
    }

    public String string() {
        return this.string;
    }

    public String toString() {
        return "<Text: \"" + this.string + "\" left=" + this.left + " bottom=" + this.bottom + " width=" + this.width() + " height=" + this.height() + ">";
    }

    public int top() {
        return this.bottom - this.height();
    }

    public void top(int n) {
        this.bottom = n + this.height();
    }

    public int width() {
        this.getDimensions();
        return this.width;
    }
}

