/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.DrawingWindow;
import element.Oval;
import element.Pt;
import element.Rect;

public class RoundRect
extends Rect {
    protected int cornerWidth;
    protected int cornerHeight;

    public RoundRect() {
        this(0, 0, 0, 0, 0, 0);
    }

    public RoundRect(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.cornerWidth = this.width() / 2;
        this.cornerHeight = this.height() / 2;
    }

    public RoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        super(n, n2, n3, n4);
        this.cornerWidth = Math.max(n5, 0);
        this.cornerHeight = Math.max(n6, 0);
    }

    public RoundRect(Pt pt, Pt pt2) {
        super(pt, pt2);
        this.cornerWidth = this.width() / 2;
        this.cornerHeight = this.height() / 2;
    }

    public RoundRect(Rect rect, int n, int n2) {
        this(rect.left(), rect.top(), rect.width(), rect.height(), n, n2);
    }

    public RoundRect(RoundRect roundRect) {
        super(roundRect);
        this.cornerWidth = roundRect.cornerWidth;
        this.cornerHeight = roundRect.cornerHeight;
    }

    public void clearOn(DrawingWindow drawingWindow) {
        drawingWindow.clearRoundRect(this.left, this.top, this.width, this.height, this.cornerWidth, this.cornerHeight);
    }

    public Object clone() {
        return new RoundRect(this);
    }

    public boolean contains(Pt pt) {
        Rect rect = new Rect(this);
        rect.extend(-this.cornerWidth / 2, 0);
        if (rect.contains(pt)) {
            return true;
        }
        rect.extend(this.cornerWidth / 2, -this.cornerHeight / 2);
        if (rect.contains(pt)) {
            return true;
        }
        rect = new Oval(0, 0, this.cornerWidth, this.cornerHeight);
        rect.left(this.left());
        rect.top(this.top());
        if (rect.contains(pt)) {
            return true;
        }
        rect.right(this.right());
        if (rect.contains(pt)) {
            return true;
        }
        rect.bottom(this.bottom());
        if (rect.contains(pt)) {
            return true;
        }
        rect.left(this.left());
        return rect.contains(pt);
    }

    public int cornerHeight() {
        return this.cornerHeight;
    }

    public void cornerHeight(int n) {
        this.cornerHeight = Math.max(n, 0);
    }

    public int cornerWidth() {
        return this.cornerWidth;
    }

    public void cornerWidth(int n) {
        this.cornerWidth = Math.max(n, 0);
    }

    public void drawOn(DrawingWindow drawingWindow) {
        drawingWindow.drawRoundRect(this.left, this.top, this.width, this.height, this.cornerWidth, this.cornerHeight);
    }

    public boolean equals(Object object) {
        RoundRect roundRect = (RoundRect)object;
        return this.left == roundRect.left && this.top == roundRect.top && this.width == roundRect.width && this.height == roundRect.height && this.cornerWidth == roundRect.cornerWidth && this.cornerHeight == roundRect.cornerHeight;
    }

    public void fillOn(DrawingWindow drawingWindow) {
        drawingWindow.fillRoundRect(this.left, this.top, this.width, this.height, this.cornerWidth, this.cornerHeight);
    }

    public int hashCode() {
        return this.left + this.top + this.width + this.height + this.cornerWidth + this.cornerHeight;
    }

    public String toString() {
        return "<RoundRect: left=" + this.left + " top=" + this.top + " width=" + this.width + " height=" + this.height + " corner width=" + this.cornerWidth + " corner height=" + this.cornerHeight + ">";
    }
}

