/*
 * Decompiled with CFR 0.152.
 */
package element;

import element.Drawable;
import element.DrawingWindow;
import element.Line;
import element.Pt;
import java.awt.Rectangle;

public class Rect
implements Drawable {
    protected int left;
    protected int top;
    protected int width;
    protected int height;

    public Rect() {
        this(0, 0, 0, 0);
    }

    public Rect(int n, int n2, int n3) {
        this(n - n3, n2 - n3, 2 * n3, 2 * n3);
    }

    public Rect(int n, int n2, int n3, int n4) {
        this.left = n;
        this.top = n2;
        this.width = n3 >= 0 ? n3 : 0;
        this.height = n4 >= 0 ? n4 : 0;
    }

    public Rect(Drawable drawable) {
        this.left = drawable.left();
        this.top = drawable.top();
        this.width = drawable.width();
        this.height = drawable.height();
    }

    public Rect(Pt pt, int n) {
        this(pt.x(), pt.y(), n);
    }

    public Rect(Pt pt, Pt pt2) {
        int n = pt.x();
        int n2 = pt2.x();
        int n3 = pt.y();
        int n4 = pt2.y();
        this.left = Math.min(n, n2);
        this.top = Math.min(n3, n4);
        this.width = Math.abs(n - n2);
        this.height = Math.abs(n3 - n4);
    }

    public Rectangle Rectangle() {
        return new Rectangle(this.left, this.top, this.width, this.height);
    }

    public int bottom() {
        return this.top + this.height;
    }

    public void bottom(int n) {
        this.top = n - this.height;
    }

    public Pt center() {
        return new Pt(this.left + this.width / 2, this.top + this.height / 2);
    }

    public void center(Pt pt) {
        this.left(pt.x() - this.width / 2);
        this.top(pt.y() - this.height / 2);
    }

    public void clearOn(DrawingWindow drawingWindow) {
        drawingWindow.clearRect(this.left, this.top, this.width, this.height);
    }

    public Object clone() {
        return new Rect(this);
    }

    public boolean contains(Pt pt) {
        return Line.within(pt.x(), this.left, this.width) && Line.within(pt.y(), this.top, this.height);
    }

    public void drawOn(DrawingWindow drawingWindow) {
        drawingWindow.drawRect(this.left, this.top, this.width, this.height);
    }

    public boolean equals(Object object) {
        Rect rect = (Rect)object;
        return this.left == rect.left && this.top == rect.top && this.width == rect.width && this.height == rect.height;
    }

    public void extend(int n, int n2) {
        if (-2 * n > this.width) {
            this.left += this.width / 2;
            this.width = 0;
        } else {
            this.left -= n;
            this.width += 2 * n;
        }
        if (-2 * n2 > this.height) {
            this.top += this.height / 2;
            this.height = 0;
        } else {
            this.top -= n2;
            this.height += 2 * n2;
        }
    }

    public void fillOn(DrawingWindow drawingWindow) {
        drawingWindow.fillRect(this.left, this.top, this.width, this.height);
    }

    public int hashCode() {
        return this.left + this.top + this.width + this.height;
    }

    public int height() {
        return this.height;
    }

    public void height(int n) {
        n = Math.max(n, 0);
        this.top += (this.height - n) / 2;
        this.height = n;
    }

    public int left() {
        return this.left;
    }

    public void left(int n) {
        this.left = n;
    }

    public void move(int n, int n2) {
        this.left += n;
        this.top += n2;
    }

    public void moveTo(int n, int n2) {
        this.left = n;
        this.top = n2;
    }

    public void moveTo(Pt pt) {
        this.moveTo(pt.x(), pt.y());
    }

    public int right() {
        return this.left + this.width;
    }

    public void right(int n) {
        this.left = n - this.width;
    }

    public String toString() {
        return "<Rectangle: left=" + this.left + " top=" + this.top + " width=" + this.width + " height=" + this.height + ">";
    }

    public int top() {
        return this.top;
    }

    public void top(int n) {
        this.top = n;
    }

    public int width() {
        return this.width;
    }

    public void width(int n) {
        n = Math.max(n, 0);
        this.left += (this.width - n) / 2;
        this.width = n;
    }
}

